/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lib.toma.animations.Keyframes;
import lib.toma.animations.QuickSort;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.engine.frame.FrameProviderType;
import lib.toma.animations.engine.frame.KeyframeProvider;
import lib.toma.animations.engine.frame.MutableKeyframe;
import lib.toma.animations.engine.frame.NoFramesProvider;
import lib.toma.animations.engine.frame.SingleFrameProvider;
import lib.toma.animations.engine.frame.TargetAndBackFrameProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.vector.Vector3d;

public class AnimatorFrameProvider
implements IKeyframeProvider {
    private final Map<AnimationStage, List<MutableKeyframe>> frameMap = new TreeMap<AnimationStage, List<MutableKeyframe>>(AnimationStage::compareTo);
    private final List<IAnimationEvent> eventList = new ArrayList<IAnimationEvent>();
    private final boolean events;
    private final Map<AnimationStage, Integer> frameCache = new HashMap<AnimationStage, Integer>();
    private byte eventIndex;
    private float animationEnd;

    public AnimatorFrameProvider(IKeyframeProvider provider) {
        this.events = provider.getType().areEventsSupported();
        if (this.events) {
            this.eventList.addAll(Arrays.asList(provider.getEvents()));
            this.eventList.sort(Comparator.comparingDouble(IAnimationEvent::invokeAt));
        }
        Map<AnimationStage, IKeyframe[]> rawFrames = provider.getFrameMap();
        for (Map.Entry<AnimationStage, IKeyframe[]> entry : rawFrames.entrySet()) {
            AnimationStage stage = entry.getKey();
            IKeyframe[] array = entry.getValue();
            if (array.length == 0) continue;
            ArrayList list = new ArrayList();
            Arrays.stream(array).map(MutableKeyframe::fullCopyOf).forEach(list::add);
            this.frameMap.put(stage, list);
        }
        provider.initCache(this.frameCache);
        this.computeAnimationEndpoint();
    }

    public AnimatorFrameProvider(Map<AnimationStage, List<MutableKeyframe>> frameMap, IAnimationEvent ... events) {
        this.events = true;
        frameMap.forEach((stage, list) -> {
            List copyList = list.stream().map(MutableKeyframe::fullCopyOf).collect(Collectors.toList());
            this.frameMap.put((AnimationStage)stage, copyList);
        });
        this.frameMap.keySet().forEach(stage -> this.frameCache.put((AnimationStage)stage, 0));
        Arrays.stream(events).map(event -> event.copyAt(event.invokeAt())).forEach(this.eventList::add);
    }

    @Override
    public boolean shouldAdvance(AnimationStage stage, float progress, int frameIndex) {
        List<MutableKeyframe> list = this.frameMap.get(stage);
        if (list == null || frameIndex >= list.size() - 1) {
            return false;
        }
        MutableKeyframe frame = list.get(frameIndex);
        return frame.endpoint() <= progress;
    }

    @Override
    public IKeyframe getCurrentFrame(AnimationStage stage, float progress, int frameIndex) {
        return this.frameMap.get(stage).get(frameIndex);
    }

    @Override
    public IKeyframe getOldFrame(AnimationStage stage, int frameIndex) {
        return frameIndex == 0 ? Keyframes.none() : (IKeyframe)this.frameMap.get(stage).get(frameIndex - 1);
    }

    @Override
    public IAnimationEvent[] getEvents() {
        return this.eventList.toArray(IAnimationEvent.NO_EVENTS);
    }

    @Override
    public Map<AnimationStage, IKeyframe[]> getFrameMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FrameProviderType<?> getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initCache(Map<AnimationStage, Integer> cache) {
        throw new UnsupportedOperationException();
    }

    public void recompile(AnimationStage stage) {
        List<MutableKeyframe> list = this.frameMap.get(stage);
        this.sort(stage);
        if (list != null) {
            int size = list.size();
            if (size > 0) {
                this.resetFirstFrame(list.get(0));
            }
            if (size > 1) {
                for (int i = 1; i < list.size(); ++i) {
                    IKeyframe parent = list.get(i - 1);
                    IKeyframe child = list.get(i);
                    child.baseOn(parent);
                }
            }
        }
        this.computeAnimationEndpoint();
    }

    public void deleteStage(AnimationStage stage) {
        this.frameMap.remove(stage);
        this.frameCache.remove(stage);
    }

    public Map<AnimationStage, List<MutableKeyframe>> getFrames() {
        return this.frameMap;
    }

    public void onProgressed(float progress, float progressOld, IAnimation source) {
        this.invokeEventsRecursive(source, progress, progressOld);
    }

    public void forceProgress(float progress) {
        Set<AnimationStage> set = this.frameMap.keySet();
        this.clrAndAdjustCache(progress, set);
    }

    public boolean blocksStageAnimation(AnimationStage stage) {
        return !this.frameCache.containsKey(stage);
    }

    public IKeyframe getActualFrame(AnimationStage stage, float progress) {
        int index = this.frameCache.get(stage);
        if (this.shouldAdvance(stage, progress, index)) {
            this.frameCache.put(stage, ++index);
        }
        return this.getCurrentFrame(stage, progress, index);
    }

    public IKeyframe getLastFrame(AnimationStage stage) {
        return this.getOldFrame(stage, this.frameCache.get(stage));
    }

    public IKeyframeProvider toSerializable() {
        boolean tAndBack;
        if (this.frameMap.isEmpty()) {
            return NoFramesProvider.empty();
        }
        boolean events = !this.eventList.isEmpty();
        boolean singleFrame = !events && this.checkSingleFrame();
        boolean bl = tAndBack = !events && this.checkTargetAndBack();
        if (singleFrame) {
            return this.constructSingleFrameProvider();
        }
        if (tAndBack) {
            return this.constructTargetAndBackProvider();
        }
        return this.constructFullProvider();
    }

    public boolean canAddEvents() {
        return this.events;
    }

    public void addEvent(IAnimationEvent event) {
        this.eventList.add(event);
        this.eventList.sort(Comparator.comparingDouble(IAnimationEvent::invokeAt));
    }

    public void removeEvent(IAnimationEvent event) {
        this.eventList.remove(event);
    }

    public void addFrame(AnimationStage stage, MutableKeyframe frame) {
        List list = this.frameMap.computeIfAbsent(stage, key -> new ArrayList());
        list.add(frame);
        this.sortAndCompile(list);
        this.onStageAdded(stage);
        this.computeAnimationEndpoint();
    }

    public void removeFrame(AnimationStage stage, MutableKeyframe frame) {
        List<MutableKeyframe> list = this.frameMap.get(stage);
        if (list != null) {
            if (list.remove(frame)) {
                this.sortAndCompile(list);
                int index = this.frameCache.get(stage);
                if (index >= list.size()) {
                    this.frameCache.put(stage, list.size() - 1);
                }
            }
            if (list.isEmpty()) {
                this.deleteStage(stage);
            }
        }
        this.computeAnimationEndpoint();
    }

    public void sort(AnimationStage stage) {
        List<MutableKeyframe> list = this.frameMap.get(stage);
        if (list == null) {
            return;
        }
        this.sortAndCompile(list);
    }

    public void merge(AnimatorFrameProvider provider, float start, float end) {
        for (Map.Entry<AnimationStage, List<MutableKeyframe>> entry : provider.frameMap.entrySet()) {
            AnimationStage stage = entry.getKey();
            List<MutableKeyframe> frames = entry.getValue();
            for (MutableKeyframe keyframe : frames) {
                MutableKeyframe copy = MutableKeyframe.copyOf(keyframe);
                float endpoint = keyframe.endpoint();
                float mergeEndpoint = start + endpoint * (end - start);
                copy.setEndpoint(mergeEndpoint);
                this.addFrame(stage, copy);
            }
        }
        for (IAnimationEvent event : provider.eventList) {
            float mergePoint = start + event.invokeAt() * (end - start);
            this.addEvent(event.copyAt(mergePoint));
        }
    }

    public float getAnimationEnd() {
        return this.animationEnd;
    }

    private boolean checkSingleFrame() {
        return this.isWithinFrameCount(size -> size <= 1);
    }

    private boolean checkTargetAndBack() {
        return this.frameMap.size() == 1 && this.isWithinFrameCount(size -> size == 2);
    }

    private IKeyframeProvider constructSingleFrameProvider() {
        HashMap<AnimationStage, IKeyframe> map = new HashMap<AnimationStage, IKeyframe>();
        for (Map.Entry<AnimationStage, List<MutableKeyframe>> entry : this.frameMap.entrySet()) {
            List<MutableKeyframe> list = entry.getValue();
            if (list.isEmpty()) continue;
            map.put(entry.getKey(), list.get(0));
        }
        return SingleFrameProvider.fromExistingMap(map);
    }

    private IKeyframeProvider constructTargetAndBackProvider() {
        Iterator<Map.Entry<AnimationStage, List<MutableKeyframe>>> iterator = this.frameMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<AnimationStage, List<MutableKeyframe>> entry = iterator.next();
            AnimationStage target = entry.getKey();
            List<MutableKeyframe> list = entry.getValue();
            MutableKeyframe toTarget = list.get(0);
            MutableKeyframe fromTarget = list.get(1);
            return new TargetAndBackFrameProvider(target, toTarget, fromTarget);
        }
        throw new IllegalStateException("Frame map was empty. How is this possible?");
    }

    private IKeyframeProvider constructFullProvider() {
        HashMap<AnimationStage, IKeyframe[]> map = new HashMap<AnimationStage, IKeyframe[]>();
        for (Map.Entry<AnimationStage, List<MutableKeyframe>> entry : this.frameMap.entrySet()) {
            AnimationStage stage = entry.getKey();
            List<MutableKeyframe> frames = entry.getValue();
            IKeyframe[] array = frames.toArray(new IKeyframe[0]);
            QuickSort.sort(array, Comparator.comparingDouble(IKeyframe::endpoint));
            map.put(stage, array);
        }
        return new KeyframeProvider(map, this.eventList.isEmpty() ? IAnimationEvent.NO_EVENTS : this.eventList.toArray(IAnimationEvent.NO_EVENTS));
    }

    private boolean isWithinFrameCount(Predicate<Integer> sizePredicate) {
        for (Map.Entry<AnimationStage, List<MutableKeyframe>> entry : this.frameMap.entrySet()) {
            int size = entry.getValue().size();
            if (sizePredicate.test(size)) continue;
            return false;
        }
        return true;
    }

    private void onStageAdded(AnimationStage stage) {
        this.frameCache.put(stage, 0);
    }

    private void clrAndAdjustCache(float progress, Set<AnimationStage> set) {
        this.eventIndex = 0;
        set.forEach(stage -> this.frameCache.put((AnimationStage)stage, 0));
        while (this.hasFrameAdvanced(progress, set)) {
        }
    }

    private boolean hasFrameAdvanced(float progress, Set<AnimationStage> set) {
        boolean changed = false;
        for (AnimationStage stage : set) {
            int index;
            if (!this.shouldAdvance(stage, progress, index = this.frameCache.get(stage).intValue())) continue;
            this.frameCache.put(stage, index + 1);
            changed = true;
        }
        return changed;
    }

    private void invokeEventsRecursive(IAnimation source, float progress, float progressOld) {
        if (this.eventIndex >= this.eventList.size()) {
            return;
        }
        IAnimationEvent event = this.eventList.get(this.eventIndex);
        float target = event.invokeAt();
        if (progress >= target && progressOld < target) {
            this.eventIndex = (byte)(this.eventIndex + 1);
            event.dispatch(Minecraft.func_71410_x(), source);
            this.invokeEventsRecursive(source, progress, progressOld);
        }
    }

    private void sortAndCompile(List<MutableKeyframe> list) {
        list.sort(Comparator.comparingDouble(IKeyframe::endpoint));
        if (!list.isEmpty()) {
            this.resetFirstFrame(list.get(0));
        }
        for (int i = 1; i < list.size(); ++i) {
            IKeyframe parent = list.get(i - 1);
            IKeyframe child = list.get(i);
            child.baseOn(parent);
        }
        this.computeAnimationEndpoint();
    }

    public void resetFirstFrame(MutableKeyframe keyframe) {
        keyframe.setPos0(Vector3d.field_186680_a);
        keyframe.setRot0(Vector3d.field_186680_a);
    }

    private void computeAnimationEndpoint() {
        OptionalDouble optional = this.frameMap.values().stream().flatMap(Collection::stream).mapToDouble(MutableKeyframe::endpoint).max();
        this.animationEnd = (float)optional.orElse(1.0);
    }
}

